/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.cpaexample.service.user;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class UserService
implements BundleActivator {
    private static String fileName = "/tmp/osgiuser";
    private BundleContext bc;

    public void start(BundleContext bc) throws BundleException {
        this.bc = bc;
        bc.registerService(UserService.class.getName(), (Object)this, null);
    }

    public void stop(BundleContext context) {
    }

    public void login(final String name) {
        final File f = new File(fileName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (f.exists()) {
                    throw new IllegalStateException("User already logged in");
                }
                try {
                    FileOutputStream os = new FileOutputStream(f);
                    ((OutputStream)os).write(name.getBytes("UTF-8"));
                    ((OutputStream)os).close();
                    UserService.this.log(3, "User " + name + " logged in");
                }
                catch (IOException ioe) {
                    UserService.this.log(2, "Problem logging user in: " + ioe);
                }
                return null;
            }
        });
    }

    public void logout() {
        final File f = new File(fileName);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (!f.exists()) {
                    throw new IllegalStateException("No user logged in");
                }
                f.delete();
                UserService.this.log(3, "User logged out");
                return null;
            }
        });
    }

    private void log(int level, String message) {
        ServiceReference sRef = this.bc.getServiceReference(LogService.class.getName());
        if (sRef != null) {
            LogService log = (LogService)this.bc.getService(sRef);
            if (log != null) {
                log.log(level, message);
            }
            this.bc.ungetService(sRef);
        }
    }
}

