/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.desktop;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.knopflerfish.service.desktop.BundleSelectionListener;
import org.knopflerfish.service.desktop.BundleSelectionModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBundleSelectionModel
implements BundleSelectionModel {
    Set<Long> selection = new HashSet<Long>();
    Set<BundleSelectionListener> listeners = new HashSet<BundleSelectionListener>();
    boolean bInFireChange = false;

    @Override
    public void clearSelection() {
        this.selection.clear();
        this.fireChange(-1L);
    }

    @Override
    public int getSelectionCount() {
        return this.selection.size();
    }

    @Override
    public long getSelected() {
        return this.selection.size() > 0 ? this.selection.iterator().next() : -1L;
    }

    @Override
    public boolean isSelected(long bid) {
        return this.selection.contains(new Long(bid));
    }

    @Override
    public void setSelected(long bid, boolean bSelected) {
        if (bSelected) {
            this.selection.add(new Long(bid));
        } else {
            this.selection.remove(new Long(bid));
        }
        this.fireChange(bid);
    }

    @Override
    public void setSelected(List<Long> bids, boolean bSelected) {
        if (null == bids || 0 == bids.size()) {
            return;
        }
        if (bSelected) {
            this.selection.addAll(bids);
        } else {
            this.selection.removeAll(bids);
        }
        this.fireChange(bids.iterator().next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundleSelectionListener(BundleSelectionListener l) {
        Set<BundleSelectionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleSelectionListener(BundleSelectionListener l) {
        Set<BundleSelectionListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(long bid) {
        Set<BundleSelectionListener> set = this.listeners;
        synchronized (set) {
            try {
                if (!this.bInFireChange) {
                    this.bInFireChange = true;
                    for (BundleSelectionListener l : this.listeners) {
                        l.valueChanged(bid);
                    }
                }
            }
            finally {
                this.bInFireChange = false;
            }
        }
    }
}

