/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util.workerthread;

import org.knopflerfish.util.workerthread.Job;
import org.knopflerfish.util.workerthread.WorkerThread;

public abstract class RepeatingJob
extends Job {
    private int[] delays;
    int repeatsMade = 0;
    private int repeatPolicy;
    boolean quit = false;

    public RepeatingJob(int[] delays, int repeatPolicy) {
        this.delays = delays;
        this.repeatPolicy = repeatPolicy;
    }

    final void run(WorkerThread workerthread) throws Exception {
        if (this.quit) {
            return;
        }
        this.run();
        int nextdelay = this.repeatPolicy;
        if (this.delays != null && this.repeatsMade < this.delays.length) {
            nextdelay = this.delays[this.repeatsMade];
        }
        ++this.repeatsMade;
        if (this.quit) {
            return;
        }
        if (nextdelay > 0) {
            workerthread.delayedJobQueueAdd(this, nextdelay);
        }
    }

    public void quit() {
        this.quit = true;
    }

    public int getRepeatNo() {
        return this.repeatsMade;
    }
}

