/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Text {
    protected static String WHITESPACE = " \t\n\r";
    protected static char CITCHAR = (char)34;
    static final Comparator strComp = new Comparator(){

        public int compare(Object oa, Object ob) throws ClassCastException {
            String a = (String)oa;
            String b = (String)ob;
            return a.compareTo(b);
        }
    };

    public static String getParam(String s, String param, String def) {
        if (s == null || param == null) {
            return def;
        }
        int ix = s.indexOf(param + "=");
        if (ix < 0) {
            return def;
        }
        int startIdx = ix + param.length() + 1;
        int endIdx = s.indexOf("::", startIdx);
        if (endIdx < 0) {
            endIdx = s.length();
        }
        try {
            return s.substring(startIdx, endIdx);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String replace(String s, String v1, String v2) {
        if (s == null || v1 == null || v2 == null || v1.length() == 0 || v1.equals(v2)) {
            return s;
        }
        int ix = 0;
        int v1Len = v1.length();
        int n = 0;
        while (-1 != (ix = s.indexOf(v1, ix))) {
            ++n;
            ix += v1Len;
        }
        if (n == 0) {
            return s;
        }
        int start = 0;
        int v2Len = v2.length();
        char[] r = new char[s.length() + n * (v2Len - v1Len)];
        int rPos = 0;
        while (-1 != (ix = s.indexOf(v1, start))) {
            while (start < ix) {
                r[rPos++] = s.charAt(start++);
            }
            for (int j = 0; j < v2Len; ++j) {
                r[rPos++] = v2.charAt(j);
            }
            start += v1Len;
        }
        ix = s.length();
        while (start < ix) {
            r[rPos++] = s.charAt(start++);
        }
        return new String(r);
    }

    public static String replace(String s, String v1, int v2) {
        return Text.replace(s, v1, Integer.toString(v2));
    }

    public static String replace(String s, String v1, boolean v2) {
        return Text.replace(s, v1, v2 ? "true" : "false");
    }

    public static String untabify(String s, int tabSize) {
        StringBuffer sb = new StringBuffer(s);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '\t') continue;
            String toinsert = "        ".substring(0, tabSize - i % tabSize);
            if (toinsert.length() == 0) {
                sb = new StringBuffer(sb.toString().substring(0, i) + sb.toString().substring(i + 1));
                continue;
            }
            sb.setCharAt(i, ' ');
            if (toinsert.length() <= 1) continue;
            sb.insert(i, toinsert.substring(1));
        }
        return sb.toString();
    }

    public static String formatJavaType(String s, String[] prefixIgnore) {
        for (int i = 0; i < prefixIgnore.length; ++i) {
            if (!s.startsWith(prefixIgnore[i])) continue;
            return s.substring(prefixIgnore[i].length());
        }
        if (s.startsWith("[L") && s.endsWith(";")) {
            return Text.formatJavaType(s.substring(2, s.length() - 1), prefixIgnore) + "[]";
        }
        return s;
    }

    public static String capitalize(String s) {
        return s.equals("") || s == null ? s : s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String[] splitwords(String s) {
        return Text.splitwords(s, WHITESPACE);
    }

    public static String[] splitwords(String s, String whiteSpace) {
        return Text.splitwords(s, WHITESPACE, CITCHAR);
    }

    public static String[] splitwords(String s, String whiteSpace, char citChar) {
        boolean bCit = false;
        Vector<String> v = new Vector<String>();
        StringBuffer buf = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (bCit || whiteSpace.indexOf(c) == -1) {
                if (c == citChar) {
                    bCit = !bCit;
                } else {
                    if (buf == null) {
                        buf = new StringBuffer();
                    }
                    buf.append(c);
                }
                ++i;
                continue;
            }
            if (buf != null) {
                v.addElement(buf.toString());
                buf = null;
            }
            while (i < s.length() && -1 != whiteSpace.indexOf(s.charAt(i))) {
                ++i;
            }
        }
        if (buf != null) {
            v.addElement(buf.toString());
        }
        Object[] r = new String[v.size()];
        v.copyInto(r);
        return r;
    }

    public static String[] split(String s, String sep) {
        StringTokenizer st = new StringTokenizer(s, sep);
        int ntok = st.countTokens();
        String[] res = new String[ntok];
        for (int i = 0; i < ntok; ++i) {
            res[i] = st.nextToken();
        }
        return res;
    }

    public static String join(Object[] s, String sep) {
        StringBuffer buf = new StringBuffer();
        int l = s.length;
        if (l > 0) {
            buf.append(s[0].toString());
        }
        for (int i = 1; i < l; ++i) {
            buf.append(sep);
            buf.append(s[i].toString());
        }
        return buf.toString();
    }

    public static Object[] toArray(Vector v) {
        int size = v.size();
        Object[] o = new Object[size];
        for (int i = 0; i < size; ++i) {
            o[i] = v.elementAt(i);
        }
        return o;
    }

    public static ArrayList parseEnumeration(String d, String s) {
        ArrayList<String> result = new ArrayList<String>();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String key;
                if ((key = at.getKey()) == null) {
                    throw new IllegalArgumentException("Directive " + d + ", unexpected character at: " + at.getRest());
                }
                if (!at.getEntryEnd()) {
                    throw new IllegalArgumentException("Directive " + d + ", expected end of entry at: " + at.getRest());
                }
                int i = Math.abs(Text.binarySearch(result, strComp, key) + 1);
                result.add(i, key);
            } while (!at.getEnd());
            return result;
        }
        return null;
    }

    public static int binarySearch(List pl, Comparator c, Object p) {
        int l = 0;
        int u = pl.size() - 1;
        while (l <= u) {
            int m = (l + u) / 2;
            int v = c.compare(pl.get(m), p);
            if (v > 0) {
                l = m + 1;
                continue;
            }
            if (v < 0) {
                u = m - 1;
                continue;
            }
            return m;
        }
        return -(l + 1);
    }

    public static Iterator parseEntries(String a, String s, boolean single, boolean unique, boolean single_entry) {
        ArrayList result = new ArrayList();
        if (s != null) {
            AttributeTokenizer at = new AttributeTokenizer(s);
            do {
                String param;
                ArrayList<String> keys = new ArrayList<String>();
                HashMap<String, Object> params = new HashMap<String, Object>();
                String key = at.getKey();
                if (key == null) {
                    throw new IllegalArgumentException("Definition, " + a + ", expected key at: " + at.getRest());
                }
                if (!single) {
                    keys.add(key);
                    while ((key = at.getKey()) != null) {
                        keys.add(key);
                    }
                }
                while ((param = at.getParam()) != null) {
                    ArrayList<String> old = (ArrayList<String>)params.get(param);
                    boolean is_directive = at.isDirective();
                    if (old != null && unique) {
                        throw new IllegalArgumentException("Definition, " + a + ", duplicate " + (is_directive ? "directive" : "attribute") + ": " + param);
                    }
                    String value = at.getValue();
                    if (value == null) {
                        throw new IllegalArgumentException("Definition, " + a + ", expected value at: " + at.getRest());
                    }
                    if (is_directive) {
                        // empty if block
                    }
                    if (unique) {
                        params.put(param, value);
                        continue;
                    }
                    if (old == null) {
                        old = new ArrayList<String>();
                        params.put(param, old);
                    }
                    old.add(value);
                }
                if (at.getEntryEnd()) {
                    if (single) {
                        params.put("key", key);
                    } else {
                        params.put("keys", keys);
                    }
                } else {
                    throw new IllegalArgumentException("Definition, " + a + ", expected end of entry at: " + at.getRest());
                }
                result.add(params);
                if (!single_entry || at.getEnd()) continue;
                throw new IllegalArgumentException("Definition, " + a + ", expected end of single entry at: " + at.getRest());
            } while (!at.getEnd());
        }
        return result.iterator();
    }

    public static boolean containsIgnoreCase(List l, List l2) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            Iterator j = l2.iterator();
            while (j.hasNext()) {
                if (!s.equalsIgnoreCase((String)j.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static class AttributeTokenizer {
        String s;
        int length;
        int pos = 0;

        AttributeTokenizer(String input) {
            this.s = input;
            this.length = this.s.length();
        }

        String getWord() {
            this.skipWhite();
            boolean backslash = false;
            boolean quote = false;
            StringBuffer val = new StringBuffer();
            int end = 0;
            block5: while (this.pos < this.length) {
                if (backslash) {
                    backslash = false;
                    val.append(this.s.charAt(this.pos));
                } else {
                    char c = this.s.charAt(this.pos);
                    switch (c) {
                        case '\"': {
                            quote = !quote;
                            end = val.length();
                            break;
                        }
                        case '\\': {
                            backslash = true;
                            break;
                        }
                        case ',': 
                        case ':': 
                        case ';': 
                        case '=': {
                            if (!quote) break block5;
                        }
                        default: {
                            val.append(c);
                            if (Character.isWhitespace(c)) break;
                            end = val.length();
                        }
                    }
                }
                ++this.pos;
            }
            if (quote || backslash || end == 0) {
                return null;
            }
            char[] res = new char[end];
            val.getChars(0, end, res, 0);
            return new String(res);
        }

        String getKey() {
            String res;
            if (this.pos >= this.length) {
                return null;
            }
            int save = this.pos;
            if (this.s.charAt(this.pos) == ';') {
                ++this.pos;
            }
            if ((res = this.getWord()) != null) {
                if (this.pos == this.length) {
                    return res;
                }
                char c = this.s.charAt(this.pos);
                if (c == ';' || c == ',') {
                    return res;
                }
            }
            this.pos = save;
            return null;
        }

        String getParam() {
            if (this.pos == this.length || this.s.charAt(this.pos) != ';') {
                return null;
            }
            int save = this.pos++;
            String res = this.getWord();
            if (res != null) {
                if (this.pos < this.length && this.s.charAt(this.pos) == '=') {
                    return res;
                }
                if (this.pos + 1 < this.length && this.s.charAt(this.pos) == ':' && this.s.charAt(this.pos + 1) == '=') {
                    return res;
                }
            }
            this.pos = save;
            return null;
        }

        boolean isDirective() {
            if (this.pos + 1 < this.length && this.s.charAt(this.pos) == ':') {
                ++this.pos;
                return true;
            }
            return false;
        }

        String getValue() {
            if (this.s.charAt(this.pos) != '=') {
                return null;
            }
            int save = this.pos++;
            this.skipWhite();
            String val = this.getWord();
            if (val == null) {
                this.pos = save;
                return null;
            }
            return val;
        }

        boolean getEntryEnd() {
            int save = this.pos;
            this.skipWhite();
            if (this.pos == this.length) {
                return true;
            }
            if (this.s.charAt(this.pos) == ',') {
                ++this.pos;
                return true;
            }
            this.pos = save;
            return false;
        }

        boolean getEnd() {
            int save = this.pos;
            this.skipWhite();
            if (this.pos == this.length) {
                return true;
            }
            this.pos = save;
            return false;
        }

        String getRest() {
            String res = this.s.substring(this.pos).trim();
            return res.length() == 0 ? "<END OF LINE>" : res;
        }

        private void skipWhite() {
            while (this.pos < this.length && Character.isWhitespace(this.s.charAt(this.pos))) {
                ++this.pos;
            }
        }
    }
}

