/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util;

public class CachedObject {
    public static final long DEFAULT_TIMEOUT = 60000L;
    private long timeout;
    private long creationTime;
    private Object object;

    public CachedObject() {
        this(null);
    }

    public CachedObject(Object object) {
        this(object, 60000L);
    }

    public CachedObject(Object object, long timeout) {
        this.timeout = timeout;
        this.set(object);
    }

    public void set(Object object) {
        this.object = object;
        this.creationTime = System.currentTimeMillis();
    }

    public Object get() {
        long now = System.currentTimeMillis();
        if (now - this.creationTime > this.timeout) {
            this.flush();
        }
        return this.object;
    }

    public void flush() {
        this.object = null;
    }

    public String toString() {
        return this.object.toString() + ":" + (System.currentTimeMillis() - this.creationTime);
    }
}

