/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util;

public class Semaphore {
    private Object value = null;
    private boolean closed = false;

    public synchronized Object get(long timeout) {
        long until = System.currentTimeMillis() + timeout;
        while (!this.closed && this.value == null) {
            try {
                long t = until - System.currentTimeMillis();
                if (t >= 0L) {
                    this.wait(t);
                    continue;
                }
                return null;
            }
            catch (InterruptedException ignore) {
            }
        }
        return this.value;
    }

    public synchronized void set(Object v) {
        if (this.closed) {
            return;
        }
        this.value = v;
        this.notifyAll();
    }

    public synchronized void reset() {
        this.value = null;
    }

    public synchronized void close() {
        this.value = null;
        this.closed = true;
        this.notifyAll();
    }
}

