/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util.framework;

import org.osgi.framework.Version;

public class VersionRange
implements Comparable {
    private final Version low;
    private final Version high;
    private final boolean lowIncluded;
    private final boolean highIncluded;
    public static final VersionRange defaultVersionRange = new VersionRange();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VersionRange(String vr) throws NumberFormatException {
        boolean op = vr.startsWith("(");
        boolean ob = vr.startsWith("[");
        if (op || ob) {
            boolean cp = vr.endsWith(")");
            boolean cb = vr.endsWith("]");
            int comma = vr.indexOf(44);
            if (comma <= 0 || !cp && !cb) throw new NumberFormatException("Illegal version range: " + vr);
            this.low = new Version(vr.substring(1, comma).trim());
            this.high = new Version(vr.substring(comma + 1, vr.length() - 1).trim());
            this.lowIncluded = ob;
            this.highIncluded = cb;
            return;
        } else {
            this.low = new Version(vr);
            this.high = null;
            this.lowIncluded = true;
            this.highIncluded = false;
        }
    }

    protected VersionRange() {
        this.low = Version.emptyVersion;
        this.high = null;
        this.lowIncluded = true;
        this.highIncluded = false;
    }

    public boolean isSpecified() {
        return this != defaultVersionRange;
    }

    public boolean withinRange(Version ver) {
        if (this == defaultVersionRange) {
            return true;
        }
        int c = this.low.compareTo((Object)ver);
        if (c < 0 || c == 0 && this.lowIncluded) {
            if (this.high == null) {
                return true;
            }
            c = this.high.compareTo((Object)ver);
            return c > 0 || c == 0 && this.highIncluded;
        }
        return false;
    }

    public boolean withinRange(VersionRange range) {
        if (this == range) {
            return true;
        }
        int c = this.low.compareTo((Object)range.low);
        if (c < 0 || c == 0 && this.lowIncluded == range.lowIncluded) {
            if (this.high == null) {
                return true;
            }
            c = this.high.compareTo((Object)range.high);
            return c > 0 || c == 0 && this.highIncluded == range.highIncluded;
        }
        return false;
    }

    public int compareTo(Object obj) throws ClassCastException {
        VersionRange o = (VersionRange)obj;
        return this.low.compareTo((Object)o.low);
    }

    public String toString() {
        if (this.high != null) {
            StringBuffer res = new StringBuffer();
            if (this.lowIncluded) {
                res.append('[');
            } else {
                res.append('(');
            }
            res.append(this.low.toString());
            res.append(',');
            res.append(this.high.toString());
            if (this.highIncluded) {
                res.append(']');
            } else {
                res.append(')');
            }
            return res.toString();
        }
        return this.low.toString();
    }

    public boolean equals(Object obj) throws ClassCastException {
        VersionRange o = (VersionRange)obj;
        if (this.low.equals((Object)o.low)) {
            if (this.high != null) {
                return this.high.equals((Object)o.high) && this.lowIncluded == o.lowIncluded && this.highIncluded == o.highIncluded;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.high != null) {
            return this.low.hashCode() + this.high.hashCode();
        }
        return this.low.hashCode();
    }
}

