/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util.framework;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knopflerfish.util.Text;
import org.knopflerfish.util.framework.Alias;
import org.knopflerfish.util.framework.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class ExecutableBundleActivator
implements BundleActivator {
    protected BundleContext bc;
    protected String startName;
    protected String stopName;
    protected File startFile;
    protected File stopFile;
    protected Process runProcess;
    protected boolean bProcessExitMeansStopBundle = true;
    protected String baseDirName = "exefiles";
    public static final String BUNDLE_START_EXECUTABLE = "Bundle-Start-Executable";
    public static final String BUNDLE_START_EXECUTABLE_ARGS = "Bundle-Start-Executable-Args";
    public static final String BUNDLE_STOP_EXECUTABLE_ARGS = "Bundle-Stop-Executable-Args";
    public static final String BUNDLE_STOP_EXECUTABLE = "Bundle-Stop-Executable";
    public static final String BUNDLE_EXTRACT_FILES = "Bundle-Extract-Files";
    public static final String BUNDLE_START_EXECUTABLE_EXIT_MEANS_BUNDLESTOP = "Bundle-Start-Executable-Exit-Means-Bundle-Stop";

    public void start(BundleContext bc) throws BundleException {
        this.bc = bc;
        this.debug("start " + this);
        try {
            this.initFiles();
            if (this.startFile != null) {
                String args = (String)bc.getBundle().getHeaders().get(BUNDLE_START_EXECUTABLE_ARGS);
                this.runProcess = this.runFile(this.startFile, args, false, this.isProcessExitMeansStopBundle());
            }
        }
        catch (IOException e) {
            throw new BundleException("Failed to init", (Throwable)e);
        }
    }

    public void stop(BundleContext bc) throws BundleException {
        try {
            this.debug("stop " + this);
            String stopS = (String)bc.getBundle().getHeaders().get(BUNDLE_START_EXECUTABLE_EXIT_MEANS_BUNDLESTOP);
            boolean bl = this.bProcessExitMeansStopBundle = stopS == null || "true".equals(stopS);
            if (this.runProcess != null) {
                this.runProcess.destroy();
                this.runProcess = null;
            }
            if (this.stopFile != null) {
                String args = (String)bc.getBundle().getHeaders().get(BUNDLE_STOP_EXECUTABLE_ARGS);
                this.runFile(this.stopFile, args, true, false);
            }
        }
        catch (Exception e) {
            throw new BundleException("Failed to stop bundle process", (Throwable)e);
        }
        finally {
            this.bc = null;
        }
    }

    public String getBaseDirName() {
        return this.baseDirName;
    }

    public void setBaseDirName(String s) {
        this.baseDirName = s;
    }

    public File getBaseDir() {
        return this.bc.getDataFile(this.getBaseDirName());
    }

    public boolean isProcessExitMeansStopBundle() {
        return this.bProcessExitMeansStopBundle;
    }

    public void setProcessExitMeansStopBundle(boolean b) {
        this.bProcessExitMeansStopBundle = b;
    }

    public boolean isDebug() {
        return true;
    }

    public void debug(String s) {
        this.debug(s, null);
    }

    public void debug(String s, Exception e) {
        System.out.println("ExecutableBundleActivator: " + s);
        if (e != null) {
            e.printStackTrace();
        }
    }

    protected Process runFile(File f, String args, boolean bWaitForExit, boolean bStopBundle) {
        this.debug("runFile " + f + ", wait=" + bWaitForExit);
        Process p = null;
        try {
            int i;
            File runDir = f.getParentFile();
            String filePath = f.getAbsolutePath();
            String dirPath = f.getParentFile().getAbsolutePath();
            String[] argv = null;
            String[] cmd = new String[1];
            if (args != null) {
                argv = Text.splitwords(args, " ");
                cmd = new String[argv.length + 1];
                for (i = 0; i < argv.length; ++i) {
                    String s = argv[i];
                    s = Text.replace(s, "${absfile}", filePath);
                    s = Text.replace(s, "${absdir}", dirPath);
                    s = Text.replace(s, "${file.sep}", File.separator);
                    cmd[i + 1] = s = Text.replace(s, "${path.sep}", File.pathSeparator);
                }
            }
            cmd[0] = f.getAbsolutePath();
            if (this.isDebug()) {
                for (i = 0; i < cmd.length; ++i) {
                    this.debug("cmd[" + i + "]=" + cmd[i]);
                }
            }
            p = Runtime.getRuntime().exec(cmd, null, runDir);
            String baseName = this.bc.getBundle().getBundleId() + ":" + this.getName(f.getAbsolutePath());
            ProcessThread t = new ProcessThread(baseName, p, bWaitForExit, bStopBundle);
            t.start();
            return p;
        }
        catch (Exception e) {
            if (p != null) {
                p.destroy();
            }
            throw new RuntimeException("failed to start " + f, e);
        }
    }

    void initFiles() throws IOException {
        this.initFiles((String)this.bc.getBundle().getHeaders().get(BUNDLE_START_EXECUTABLE), (String)this.bc.getBundle().getHeaders().get(BUNDLE_STOP_EXECUTABLE), (String)this.bc.getBundle().getHeaders().get(BUNDLE_EXTRACT_FILES));
    }

    protected void initFiles(String startChoices, String stopChoices, String extractNames) throws IOException {
        String startName = null;
        Collection map = this.getNativeCode(startChoices);
        if (map != null && map.size() > 0) {
            startName = (String)map.iterator().next();
        }
        String stopName = null;
        map = this.getNativeCode(stopChoices);
        if (map != null && map.size() > 0) {
            stopName = (String)map.iterator().next();
        }
        this.initFiles2(startName, stopName, extractNames);
    }

    public void initFiles2(String startName, String stopName, String extractNames) throws IOException {
        this.debug("startName=" + startName + ", stopName=" + stopName);
        this.startName = startName;
        this.stopName = stopName;
        if (extractNames != null) {
            String[] names = Text.splitwords(extractNames, ",", '\"');
            this.debug(extractNames + "->" + names.length);
            for (int i = 0; i < names.length; ++i) {
                this.extractResource(names[i]);
            }
        }
        if (startName != null) {
            this.startFile = this.extractResource(startName);
            this.setExecutable(this.startFile);
        }
        if (stopName != null) {
            this.stopFile = this.extractResource(stopName);
            this.setExecutable(this.stopFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExecutable(File f) {
        File cmdFile = this.findOSCommand("chmod");
        if (cmdFile == null) {
            this.debug("No chmod command found, ignoring setExecutable");
            return;
        }
        String[] cmd = new String[]{cmdFile.getAbsolutePath(), "a+rx", f.getAbsolutePath()};
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd, null, null);
            p.waitFor();
        }
        catch (Exception e) {
            this.debug("failed to set executable " + f, e);
        }
    }

    File findOSCommand(String cmd) {
        String[] paths = new String[]{"/bin", "/usr/bin", "/bin/local", "/usr/bin/local"};
        for (int i = 0; i < paths.length; ++i) {
            File f = new File(new File(paths[i]), cmd);
            if (!f.exists()) continue;
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File extractResource(String name) throws IOException {
        this.debug("extractResource " + name);
        URL url = this.bc.getBundle().getResource(name);
        String fname = name;
        File baseDir = this.getBaseDir();
        File f = new File(baseDir, fname);
        File dir = f.getParentFile();
        dir.mkdirs();
        BufferedInputStream bin = null;
        FilterOutputStream bout = null;
        this.debug("extract " + name + " to " + f.getAbsolutePath());
        try {
            int n;
            bin = new BufferedInputStream(url.openStream());
            bout = new BufferedOutputStream(new FileOutputStream(f));
            byte[] buf = new byte[10240];
            while (-1 != (n = bin.read(buf))) {
                ((BufferedOutputStream)bout).write(buf, 0, n);
            }
            ((BufferedOutputStream)bout).flush();
            File file = f;
            return file;
        }
        finally {
            try {
                bin.close();
            }
            catch (Exception ignored) {}
            try {
                bout.close();
            }
            catch (Exception ignored) {}
        }
    }

    String getName(String s) {
        int ix = s.lastIndexOf("/");
        if (ix == -1) {
            ix = s.lastIndexOf("\\");
        }
        if (ix != -1) {
            return s.substring(ix + 1);
        }
        return s;
    }

    private Collection getNativeCode(String bnc) {
        if (bnc != null) {
            Bundle b = this.bc.getBundle();
            Hashtable<String, String> fwprops = new Hashtable<String, String>();
            fwprops.put("org.osgi.framework.processor", this.bc.getProperty("org.osgi.framework.processor"));
            fwprops.put("org.osgi.framework.os.name", this.bc.getProperty("org.osgi.framework.os.name"));
            fwprops.put("org.osgi.framework.os.version", this.bc.getProperty("org.osgi.framework.os.version"));
            fwprops.put("org.osgi.framework.language", this.bc.getProperty("org.osgi.framework.language"));
            String proc = this.bc.getProperty("org.osgi.framework.processor");
            String os = this.bc.getProperty("org.osgi.framework.os.name");
            Version osVer = new Version(this.bc.getProperty("org.osgi.framework.os.version"));
            String osLang = this.bc.getProperty("org.osgi.framework.language");
            boolean optional = false;
            List best = null;
            VersionRange bestVer = null;
            boolean bestLang = false;
            Iterator i = Text.parseEntries("Bundle-NativeCode", bnc, false, false, false);
            while (i.hasNext()) {
                List sf;
                List lang;
                List ol;
                VersionRange matchVer = null;
                boolean matchLang = false;
                Map params = (Map)i.next();
                List keys = (List)params.get("keys");
                if (keys.size() == 1 && "*".equals(keys.get(0)) && !i.hasNext()) {
                    optional = true;
                    break;
                }
                List pl = (List)params.get("processor");
                if (pl == null || !Text.containsIgnoreCase(pl, Alias.unifyProcessor(proc)) || (ol = (List)params.get("osname")) == null || !Text.containsIgnoreCase(ol, Alias.unifyOsName(os))) continue;
                List ver = (List)params.get("osversion");
                if (ver != null) {
                    boolean okVer = false;
                    Iterator v = ver.iterator();
                    while (v.hasNext()) {
                        matchVer = new VersionRange((String)v.next());
                        if (!matchVer.withinRange(osVer)) continue;
                        okVer = true;
                        break;
                    }
                    if (!okVer) continue;
                }
                if ((lang = (List)params.get("language")) != null) {
                    Iterator l = lang.iterator();
                    while (l.hasNext()) {
                        if (!osLang.equalsIgnoreCase((String)l.next())) continue;
                        matchLang = true;
                        break;
                    }
                    if (!matchLang) continue;
                }
                if ((sf = (List)params.get("selection-filter")) != null && sf.size() == 1) {
                    Filter filter = null;
                    try {
                        filter = this.bc.createFilter((String)sf.get(0));
                    }
                    catch (InvalidSyntaxException e) {
                        throw new RuntimeException("wtf", e);
                    }
                    if (!filter.match(fwprops)) continue;
                }
                if (best != null) {
                    boolean verEqual = false;
                    if (bestVer != null) {
                        if (matchVer == null) continue;
                        int d = bestVer.compareTo(matchVer);
                        if (d == 0) {
                            verEqual = true;
                        } else if (d > 0) {
                            continue;
                        }
                    } else if (matchVer == null) {
                        verEqual = true;
                    }
                    if (verEqual && (!matchLang || bestLang)) continue;
                }
                best = keys;
                bestVer = matchVer;
                bestLang = matchLang;
            }
            return best;
        }
        return null;
    }

    class ProcessThread
    extends Thread {
        String baseName;
        Process p;
        int exitCode;
        boolean bDone = false;
        boolean bWait = false;
        boolean bStopBundle = false;
        Thread stdoutThread;
        Thread stderrThread;

        ProcessThread(String name, Process p, boolean bWait, boolean bStopBundle) {
            super(name + "::wait");
            this.baseName = name;
            this.p = p;
            this.bWait = bWait;
            this.bStopBundle = bStopBundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ExecutableBundleActivator.this.debug("waitFor " + this.getName());
                this.exitCode = this.p.waitFor();
                ExecutableBundleActivator.this.debug("done waitFor " + this.getName());
            }
            catch (InterruptedException e) {
                this.bDone = true;
                this.exitCode = -1;
            }
            finally {
                this.bDone = true;
                if (this.bStopBundle && ExecutableBundleActivator.this.bc != null) {
                    ExecutableBundleActivator.this.debug("stopping bundle");
                    try {
                        ExecutableBundleActivator.this.bc.getBundle().stop();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to stop bundle", e);
                    }
                }
            }
        }

        public void start() {
            this.bDone = false;
            this.stdoutThread = this.gobble(this.baseName + "::stdout", this.p.getInputStream());
            this.stderrThread = this.gobble(this.baseName + "::stderr", this.p.getErrorStream());
            super.start();
            if (this.bWait) {
                while (!this.bDone) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        this.bDone = true;
                    }
                }
            }
        }

        public void close() {
            this.bDone = true;
            try {
                this.join(2000L);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to close " + this.getName(), e);
            }
        }

        Thread gobble(final String name, final InputStream is) {
            Thread t = new Thread(name){

                /*
                 * Exception decompiling
                 */
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            t.start();
            return t;
        }

        static /* synthetic */ ExecutableBundleActivator access$000(ProcessThread x0) {
            return x0.ExecutableBundleActivator.this;
        }
    }
}

