/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util;

public class ByteArray {
    public static byte getByte(byte[] array, int index) {
        return (byte)ByteArray.toLong(array, index, 1);
    }

    public static short getShort(byte[] array, int index) {
        return (short)ByteArray.toLong(array, index, 2);
    }

    public static int getInt(byte[] array, int index) {
        return (int)ByteArray.toLong(array, index, 4);
    }

    public static float getFloat(byte[] array, int index) {
        return Float.intBitsToFloat(ByteArray.getInt(array, index));
    }

    public static long getLong(byte[] array, int index) {
        return ByteArray.toLong(array, index, 8);
    }

    public static double getDouble(byte[] array, int index) {
        return Double.longBitsToDouble(ByteArray.getLong(array, index));
    }

    public static int setByte(byte b, byte[] array, int index) {
        return ByteArray.toByteArray(b, array, index, 1);
    }

    public static int setShort(short s, byte[] array, int index) {
        return ByteArray.toByteArray(s, array, index, 2);
    }

    public static int setInt(int i, byte[] array, int index) {
        return ByteArray.toByteArray(i, array, index, 4);
    }

    public static int setFloat(float f, byte[] array, int index) {
        return ByteArray.toByteArray(Float.floatToIntBits(f), array, index, 4);
    }

    public static int setLong(long l, byte[] array, int index) {
        return ByteArray.toByteArray(l, array, index, 8);
    }

    public static int setDouble(double d, byte[] array, int index) {
        return ByteArray.toByteArray(Double.doubleToLongBits(d), array, index, 8);
    }

    private static long toLong(byte[] array, int index, int size) {
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            result <<= 8;
            result |= (long)(array[index + i] & 0xFF);
        }
        return result;
    }

    private static int toByteArray(long value, byte[] array, int index, int size) {
        for (int i = size - 1; i >= 0; --i) {
            array[index + i] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        return size;
    }
}

