/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util.workerthread;

import org.knopflerfish.util.workerthread.Job;
import org.knopflerfish.util.workerthread.RepeatingJob;

public class WorkerThread
extends Thread {
    private boolean quit = false;
    private boolean started = false;
    private static int nameTick = 0;
    private JobQueue jobQueue = new JobQueue();
    private JobQueue delayedJobQueue = new JobQueue();

    public WorkerThread() {
        super("WorkerThread-" + nameTick++);
    }

    public WorkerThread(String name) {
        super(name);
    }

    public WorkerThread(ThreadGroup group, String name) {
        super(group, name);
    }

    public void run() {
        this.started = true;
        this.preMainLoopHook();
        Job job = null;
        while (!this.quit) {
            try {
                job = this.waitForJob();
                this.status("Got Job", null, null);
                if (job != null) {
                    if (job instanceof RepeatingJob) {
                        ((RepeatingJob)job).run(this);
                    } else {
                        job.run();
                    }
                }
                this.status("run() OK", job, null);
            }
            catch (Exception e) {
                this.status("", null, e);
            }
        }
        this.postMainLoopHook();
    }

    protected void preMainLoopHook() {
    }

    protected void postMainLoopHook() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.quit = true;
        WorkerThread workerThread = this;
        synchronized (workerThread) {
            this.notifyAll();
        }
    }

    public boolean isRunning() {
        return this.started && !this.quit;
    }

    void delayedJobQueueAdd(Job job, long delay) {
        this.delayedJobQueue.add(job, delay);
    }

    public synchronized void addJob(Job job) {
        this.jobQueue.add(job);
        if (job instanceof RepeatingJob) {
            ((RepeatingJob)job).repeatsMade = 0;
            ((RepeatingJob)job).quit = false;
        }
        this.notifyAll();
    }

    public synchronized void addJob(Job job, long delayMillis) {
        this.delayedJobQueue.add(job, delayMillis);
        if (job instanceof RepeatingJob) {
            ((RepeatingJob)job).repeatsMade = 0;
            ((RepeatingJob)job).quit = false;
        }
        this.notifyAll();
    }

    public synchronized void removeJob(Job job) {
        this.jobQueue.removeJob(job);
        this.delayedJobQueue.removeJob(job);
    }

    private synchronized Job waitForJob() {
        while (this.jobQueue.size == 0 && !this.quit) {
            Link djl;
            long timeout = 0L;
            if (this.delayedJobQueue.size > 0 && (timeout = (djl = this.delayedJobQueue.preFirst.next).getTimeout()) <= 0L) {
                this.delayedJobQueue.removeFirst();
                this.jobQueue.add(djl);
                break;
            }
            try {
                this.status("Waiting for job (" + timeout + ")", null, null);
                if (this.delayedJobQueue.size > 0) {
                    this.wait(timeout);
                    continue;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.quit) {
            this.status("Quitting!", null, null);
            return null;
        }
        Job j = this.jobQueue.removeFirst();
        return j;
    }

    protected void status(String msg, Job job, Exception e) {
    }

    private class JobQueue {
        int size = 0;
        Link preFirst = new Link(null);
        Link postLast;

        JobQueue() {
            this.preFirst.next = this.postLast = new Link(null);
            this.postLast.prev = this.preFirst;
        }

        void add(Job job) {
            this.add(new Link(job));
        }

        void add(Link l) {
            l.insertBefore(this.postLast);
            ++this.size;
        }

        void add(Job job, long delay) {
            Link l = new Link(job);
            l.setDelay(delay);
            ++this.size;
            if (this.size == 1) {
                l.insertBefore(this.postLast);
                return;
            }
            Link al = this.preFirst.next;
            while (al != this.postLast && al.runAt <= l.runAt) {
                al = al.next;
            }
            l.insertBefore(al);
        }

        Job removeFirst() {
            if (this.size <= 0) {
                return null;
            }
            Job j = this.preFirst.next.job;
            this.preFirst.next.unlink();
            --this.size;
            return j;
        }

        void removeJob(Job job) {
            Link l = this.preFirst.next;
            Link n = null;
            while (l != this.postLast) {
                n = l.next;
                if (l.job.equals(job)) {
                    l.unlink();
                    --this.size;
                }
                l = n;
            }
        }
    }

    private class Link {
        Job job;
        long runAt = 0L;
        Link prev = null;
        Link next = null;

        Link(Job job) {
            this.job = job;
        }

        void insertBefore(Link l) {
            this.next = l;
            this.prev = l.prev;
            this.prev.next = this;
            l.prev = this;
        }

        void unlink() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
        }

        void setDelay(long delayMillis) {
            this.runAt = delayMillis + System.currentTimeMillis();
        }

        long getTimeout() {
            return this.runAt - System.currentTimeMillis();
        }
    }
}

