/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util.sort;

import java.util.Vector;
import org.knopflerfish.util.sort.CompareFunc;

public class QSort {
    protected QSort() {
    }

    public static void sort(Vector a, CompareFunc cf) {
        QSort.sort(a, 0, a.size() - 1, cf);
    }

    public static void sort(Object[] a, CompareFunc cf) {
        QSort.sort(a, 0, a.length - 1, cf);
    }

    static void sort(Object[] a, int lo0, int hi0, CompareFunc cf) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && cf.compare(a[lo], mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && cf.compare(a[hi], mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                QSort.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                QSort.sort(a, lo0, hi, cf);
            }
            if (lo < hi0) {
                QSort.sort(a, lo, hi0, cf);
            }
        }
    }

    static void sort(Vector a, int lo0, int hi0, CompareFunc cf) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            Object mid = a.elementAt((lo0 + hi0) / 2);
            while (lo <= hi) {
                while (lo < hi0 && cf.compare(a.elementAt(lo), mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && cf.compare(a.elementAt(hi), mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                QSort.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                QSort.sort(a, lo0, hi, cf);
            }
            if (lo < hi0) {
                QSort.sort(a, lo, hi0, cf);
            }
        }
    }

    private static void swap(Object[] a, int i, int j) {
        Object tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }

    private static void swap(Vector a, int i, int j) {
        Object tmp = a.elementAt(i);
        a.setElementAt(a.elementAt(j), i);
        a.setElementAt(tmp, j);
    }
}

