/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knopflerfish.util.CachedObject;

public class CacheMap
extends HashMap {
    private static final long serialVersionUID = 1L;
    protected long timeout;

    public CacheMap() {
        this(60000L);
    }

    public CacheMap(long timeout) {
        this.timeout = timeout;
    }

    public Object get(Object key) {
        CachedObject cache = (CachedObject)super.get(key);
        if (cache == null) {
            return null;
        }
        Object obj = cache.get();
        if (obj == null) {
            this.remove(key);
        }
        return obj;
    }

    public boolean containsKey(Object key) {
        return null != this.get(key);
    }

    public Object put(Object key, Object value) {
        CachedObject cache = (CachedObject)super.get(key);
        if (cache == null) {
            super.put(key, new CachedObject(value, this.timeout));
            return null;
        }
        Object old = cache.get();
        cache.set(value);
        return old;
    }

    public void update() {
        Iterator it = this.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            CachedObject cache = (CachedObject)entry.getValue();
            if (cache.get() != null) continue;
            this.remove(entry.getKey());
        }
    }
}

