/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.service.desktop;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.knopflerfish.service.desktop.BundleSelectionListener;
import org.knopflerfish.service.desktop.BundleSelectionModel;

public class DefaultBundleSelectionModel
implements BundleSelectionModel {
    Set selection = new HashSet();
    Set listeners = new HashSet();
    boolean bInFireChange = false;

    public void clearSelection() {
        this.selection.clear();
        this.fireChange(-1L);
    }

    public boolean isSelected(long bid) {
        return this.selection.contains(new Long(bid));
    }

    public void setSelected(long bid, boolean bSelected) {
        if (bSelected) {
            this.selection.add(new Long(bid));
        } else {
            this.selection.remove(new Long(bid));
        }
        this.fireChange(bid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleSelectionListener(BundleSelectionListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleSelectionListener(BundleSelectionListener l) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(long bid) {
        Set set = this.listeners;
        synchronized (set) {
            try {
                if (!this.bInFireChange) {
                    this.bInFireChange = true;
                    Iterator it = this.listeners.iterator();
                    while (it.hasNext()) {
                        BundleSelectionListener l = (BundleSelectionListener)it.next();
                        l.valueChanged(bid);
                    }
                }
            }
            finally {
                this.bInFireChange = false;
            }
        }
    }
}

