/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.Color;
import org.osgi.framework.Bundle;

public class Util {
    public static Color rgbInterpolate(Color c1, Color c2, double k) {
        if (c1 == null || c2 == null) {
            return Color.gray;
        }
        if (k <= 0.0) {
            return c1;
        }
        if (k >= 1.0) {
            return c2;
        }
        int r1 = c1.getRed();
        int g1 = c1.getGreen();
        int b1 = c1.getBlue();
        int r2 = c2.getRed();
        int g2 = c2.getGreen();
        int b2 = c2.getBlue();
        int r = (int)((double)r1 + k * (double)(r2 - r1));
        int g = (int)((double)g1 + k * (double)(g2 - g1));
        int b = (int)((double)b1 + k * (double)(b2 - b1));
        Color c = new Color(r, g, b);
        return c;
    }

    public static String stateName(int state) {
        switch (state) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 1: {
                return "uninstalled";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
        }
        return "unknown " + state;
    }

    public static String getHeader(Bundle b, String name) {
        return Util.getHeader(b, name, null);
    }

    public static String getHeader(Bundle b, String name, String def) {
        String s = b != null ? (String)b.getHeaders().get(name) : def;
        return s;
    }

    public static String getBundleName(Bundle b) {
        String s = Util.getHeader(b, "Bundle-Name", "");
        if (s == null || "".equals(s) || s.startsWith("%")) {
            s = Util.shortLocation(b.getLocation());
        }
        return s;
    }

    public static boolean canBeStarted(Bundle b) {
        return Util.hasActivator(b) || Util.hasMainClass(b);
    }

    public static boolean hasActivator(Bundle b) {
        return null != Util.getHeader(b, "Bundle-Activator");
    }

    public static boolean hasMainClass(Bundle b) {
        return null != Util.getHeader(b, "Main-class");
    }

    public static String shortLocation(String s) {
        int ix = s.lastIndexOf("/");
        if (s.endsWith("/")) {
            ix = s.lastIndexOf("/", ix - 1);
        }
        if (ix == -1) {
            ix = s.lastIndexOf("\\");
        }
        if (ix != -1) {
            return s.substring(ix + 1);
        }
        return s;
    }

    public static String replace(String s, String v1, String v2) {
        if (s == null || v1 == null || v2 == null || v1.length() == 0 || v1.equals(v2)) {
            return s;
        }
        int ix = 0;
        int v1Len = v1.length();
        int n = 0;
        while (-1 != (ix = s.indexOf(v1, ix))) {
            ++n;
            ix += v1Len;
        }
        if (n == 0) {
            return s;
        }
        int start = 0;
        int v2Len = v2.length();
        char[] r = new char[s.length() + n * (v2Len - v1Len)];
        int rPos = 0;
        while (-1 != (ix = s.indexOf(v1, start))) {
            while (start < ix) {
                r[rPos++] = s.charAt(start++);
            }
            for (int j = 0; j < v2Len; ++j) {
                r[rPos++] = v2.charAt(j);
            }
            start += v1Len;
        }
        ix = s.length();
        while (start < ix) {
            r[rPos++] = s.charAt(start++);
        }
        return new String(r);
    }
}

