/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import org.knopflerfish.bundle.desktopawt.Util;

public class LF {
    public Font defaultFont = new Font("Dialog", 0, 11);
    public Font smallFont = new Font("Dialog", 0, 10);
    public Font defaultFixedFont = new Font("Monospaced", 0, 11);
    public Font smallFixedFont = new Font("Monospaced", 0, 10);
    Color bgColor = new Color(240, 240, 240);
    Color textColor = new Color(0, 0, 0);
    Color stdHiliteCol1 = new Color(140, 140, 200);
    Color stdHiliteCol2 = new Color(255, 255, 255);
    Color stdSelectedCol = new Color(255, 200, 120);
    Color ttBg = new Color(255, 255, 200);
    Color ttText = new Color(0, 0, 0);
    Color ttBorder = new Color(120, 120, 120);
    int imgHSpace = 5;
    static LF lf = new LF();
    public static final int HORIZONTAL_LEFT = 1;
    public static final int HORIZONTAL_CENTER = 2;
    public static final int HORIZONTAL_RIGHT = 3;
    public static final int VERTICAL_TOP = 1;
    public static final int VERTICAL_CENTER = 2;
    public static final int VERTICAL_RIGHT = 3;

    public static LF getLF() {
        return lf;
    }

    public void paintButton(Graphics g, Dimension size, Color bgColor, Color hiliteCol1, Color hiliteCol2, Color selectedCol, boolean bSelected) {
        Color c;
        double k;
        int i;
        Color loColor = Util.rgbInterpolate(bgColor, hiliteCol1, 0.4);
        Color hiColor = Util.rgbInterpolate(bgColor, hiliteCol2, 0.5);
        Color medColor = Util.rgbInterpolate(loColor, hiColor, 0.5);
        int w = size.width - 1;
        int h = size.height - 1;
        int bH = 5;
        int tH = h - bH;
        for (i = 0; i <= tH; ++i) {
            k = (double)i / (double)tH - 0.2;
            c = Util.rgbInterpolate(hiColor, medColor, k);
            g.setColor(c);
            g.drawLine(1, i, w - 1, i);
        }
        for (i = 0; i <= bH; ++i) {
            k = (double)i / (double)bH;
            c = Util.rgbInterpolate(loColor, medColor, k);
            g.setColor(c);
            int x = i == 0 ? 3 : (i == 1 ? 2 : 1);
            g.drawLine(x, h - i, w - x, h - i);
        }
        if (bSelected) {
            int i2;
            Color sel1 = Util.rgbInterpolate(bgColor, selectedCol, 0.2);
            Color sel2 = Util.rgbInterpolate(bgColor, selectedCol, 0.5);
            Color sel3 = Util.rgbInterpolate(bgColor, selectedCol, 0.7);
            for (i2 = 1; i2 <= 3; ++i2) {
                g.setColor(sel3);
                g.drawRect(i2, i2, w - i2 * 2, h - i2 * 2);
            }
            this.pixel(g, sel2, i2, i2);
            this.pixel(g, sel2, w - i2, i2);
            this.pixel(g, sel2, w - i2, h - i2);
            this.pixel(g, sel2, i2, h - i2);
        }
        g.setColor(loColor);
        g.drawLine(0, 3, 0, h - 3);
        g.setColor(loColor);
        g.drawLine(3, 0, w - 3, 0);
        g.setColor(loColor);
        g.drawLine(w, 3, w, h - 3);
        Color fade1 = Util.rgbInterpolate(bgColor, loColor, 0.6);
        Color fade2 = Util.rgbInterpolate(bgColor, loColor, 0.4);
        Color fade3 = Util.rgbInterpolate(bgColor, loColor, 0.2);
        this.pixel(g, fade1, 1, 2);
        this.pixel(g, fade1, 2, 1);
        this.pixel(g, fade1, 3, 0);
        this.pixel(g, fade1, 0, 3);
        this.pixel(g, fade3, 1, 1);
        this.pixel(g, fade1, w - 1, 2);
        this.pixel(g, fade1, w - 2, 1);
        this.pixel(g, fade1, w - 3, 0);
        this.pixel(g, fade1, w - 0, 3);
        this.pixel(g, fade3, w - 1, 1);
        this.pixel(g, fade1, 1, h - 2);
        this.pixel(g, fade1, 2, h - 1);
        this.pixel(g, fade1, 3, h - 0);
        this.pixel(g, fade1, 0, h - 3);
        this.pixel(g, fade3, 1, h - 1);
        this.pixel(g, fade1, w - 1, h - 2);
        this.pixel(g, fade1, w - 2, h - 1);
        this.pixel(g, fade1, w - 3, h - 0);
        this.pixel(g, fade1, w - 0, h - 3);
        this.pixel(g, fade3, w - 1, h - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintLabel(Graphics g, Dimension size, String s, Image img, int horizontalAlign, int verticalAlign, Color color, boolean bEnabled) {
        Font font = g.getFont();
        FontMetrics fm = g.getFontMetrics();
        int sWidth = fm.stringWidth(s);
        if (img != null) {
            sWidth += img.getWidth(null) + this.imgHSpace;
        }
        g.setColor(color);
        int x = 4;
        int y = size.height / 2 + font.getSize() / 2;
        switch (horizontalAlign) {
            case 2: {
                x = size.width / 2 - sWidth / 2;
                break;
            }
            case 1: {
                x = 4;
                break;
            }
            case 3: {
                x = size.width - sWidth - 4;
            }
        }
        if (img != null) {
            int imgW = img.getWidth(null) + this.imgHSpace;
            int imgH = img.getHeight(null);
            g.drawImage(img, x, size.height / 2 - imgH / 2, null);
            x += imgW;
        }
        g.drawString(s, x, y);
    }

    public void pixel(Graphics g, Color c, int x, int y) {
        g.setColor(c);
        g.drawLine(x, y, x, y);
    }
}

