/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.zip.ZipException;
import org.knopflerfish.bundle.desktopawt.Activator;
import org.knopflerfish.bundle.desktopawt.Desktop;
import org.knopflerfish.bundle.desktopawt.ImageLabel;
import org.knopflerfish.bundle.desktopawt.LF;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class InstallPanel
extends Panel {
    TextField tf;
    TextArea msg;
    LF lf = LF.getLF();
    String defText = "Enter bundle URL\nthen select \"Install\"";
    FileDialog fd;
    FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            String s = name.toLowerCase();
            return s.endsWith(".jar") || s.endsWith(".zip");
        }
    };

    public InstallPanel() {
        this.setLayout(new BorderLayout());
        Container row = new Container();
        row.setLayout(new BorderLayout());
        this.tf = new TextField();
        this.tf.setFont(this.lf.defaultFont);
        this.tf.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10) {
                    InstallPanel.this.installBundle(InstallPanel.this.tf.getText());
                }
            }
        });
        this.msg = new TextArea(10, 10);
        this.msg.setText(this.defText);
        this.msg.setBackground(this.lf.bgColor);
        this.msg.setForeground(this.lf.textColor);
        this.msg.setFont(this.lf.smallFont);
        this.msg.setEditable(false);
        Button installB = new Button("Install");
        installB.setBackground(this.lf.bgColor);
        ImageLabel open = new ImageLabel("/open.gif", 1, this.lf.bgColor);
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                InstallPanel.this.browseFile();
            }
        });
        installB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                InstallPanel.this.installBundle(InstallPanel.this.tf.getText());
            }
        });
        row.add((Component)new Label("URL"), "West");
        row.add((Component)this.tf, "Center");
        row.add((Component)open, "East");
        row.add((Component)installB, "South");
        this.add((Component)row, "North");
        this.add((Component)this.msg, "Center");
    }

    void browseFile() {
        Object dir;
        if (this.fd == null) {
            this.fd = new FileDialog(Desktop.frame);
            ((Dialog)this.fd).setTitle("Select JAR file");
            this.fd.setFilenameFilter(this.filter);
            try {
                dir = System.getProperty("org.knopflerfish.gosg.jars");
                System.out.println("dir0=" + (String)dir);
                if (dir != null) {
                    int ix = ((String)dir).indexOf("file:");
                    if (ix != -1) {
                        dir = ((String)dir).substring(ix + 5);
                    }
                    if (((String)dir).endsWith("/")) {
                        dir = ((String)dir).substring(0, ((String)dir).length() - 1);
                    }
                    System.out.println("dir=" + (String)dir);
                } else {
                    dir = ".";
                }
                File f = new File((String)dir);
                if (f.exists()) {
                    this.fd.setDirectory((String)dir);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to set dir: " + e);
            }
        }
        this.fd.show();
        dir = new File(this.fd.getDirectory());
        String name = this.fd.getFile();
        if (dir != null && name != null) {
            File f = new File((File)dir, name);
            this.tf.setText("file:" + f.getAbsolutePath());
        }
    }

    void installBundle(String url) {
        try {
            url = url.trim();
            if (url.length() == 0) {
                this.msg.setText(this.defText);
            } else {
                Bundle b = Activator.bc.installBundle(url.trim());
                this.msg.setText("Installed " + url + "\n as bundle #" + b.getBundleId());
            }
        }
        catch (Exception e) {
            if (e instanceof BundleException) {
                Throwable nested = ((BundleException)e).getNestedException();
                if (nested instanceof ZipException) {
                    this.msg.setText(nested.getClass().getName() + "\n" + nested.getMessage() + "\n\n" + "Not a jar file?");
                    return;
                }
                if (nested instanceof IOException) {
                    this.msg.setText(nested.getClass().getName() + "\n" + nested.getMessage());
                    return;
                }
            }
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.msg.setText(sw.toString());
        }
    }
}

