/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import org.knopflerfish.bundle.desktopawt.Desktop;
import org.knopflerfish.bundle.desktopawt.LF;

public class ImageLabel
extends Component {
    Image img;
    boolean bFocus = false;
    boolean bEnabled = true;
    boolean bDoHighlight = true;
    Dimension imgSize;
    Dimension minSize;
    Hashtable actionListeners = new Hashtable();
    LF lf = LF.getLF();
    int id = 0;
    Color alphaCol = new Color(0, 0, 0, 255);

    public ImageLabel(String url, int pad, Color bg) {
        this.img = Desktop.loadImage(url);
        this.imgSize = new Dimension(this.img.getWidth(null), this.img.getHeight(null));
        this.minSize = new Dimension(this.imgSize.width + pad * 2, this.imgSize.height + pad * 2);
        this.setBackground(bg);
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.setFocus(true);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.setFocus(false);
                }
            }

            public void mouseClicked(MouseEvent e) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.setFocus(false);
                    ImageLabel.this.sendActionEvent(new ActionEvent(ImageLabel.this, ImageLabel.this.id++, ""));
                }
            }
        });
    }

    public void addActionListener(ActionListener l) {
        this.actionListeners.put(l, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void sendActionEvent(ActionEvent ev) {
        Enumeration e = this.actionListeners.keys();
        while (e.hasMoreElements()) {
            ActionListener l = (ActionListener)e.nextElement();
            try {
                l.actionPerformed(ev);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }

    public void setEnabled(boolean b) {
        this.bEnabled = b;
    }

    public void setFocus(boolean b) {
        this.bFocus = b;
        this.repaint();
    }

    public boolean isFocus() {
        return this.bFocus;
    }

    public Dimension getPreferredSize() {
        return this.minSize;
    }

    public Dimension getMinimumSize() {
        return this.minSize;
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.bFocus && this.bDoHighlight) {
            Color hiliteCol1 = this.lf.stdHiliteCol1.brighter();
            this.lf.paintButton(g, size, this.getBackground(), this.lf.stdHiliteCol1, this.lf.stdHiliteCol2, this.lf.stdSelectedCol, false);
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        int w = this.img.getWidth(null);
        int h = this.img.getHeight(null);
        g.drawImage(this.img, size.width / 2 - w / 2, size.height / 2 - h / 2, null);
    }
}

