/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.knopflerfish.bundle.desktopawt.Activator;
import org.knopflerfish.bundle.desktopawt.Console;
import org.knopflerfish.bundle.desktopawt.DBContainer;
import org.knopflerfish.bundle.desktopawt.Desktop;
import org.knopflerfish.bundle.desktopawt.ImageLabel;
import org.knopflerfish.bundle.desktopawt.InstallPanel;
import org.knopflerfish.bundle.desktopawt.LF;
import org.knopflerfish.bundle.desktopawt.ShutdownPanel;
import org.knopflerfish.bundle.desktopawt.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

class DesktopPanel
extends Panel
implements BundleListener {
    ScrollPane scroll;
    Toolbar toolbar;
    Container bundlePanel;
    Panel cardPanel;
    CardLayout cardLayout;
    Console console;
    StatusBar statusBar;
    Container openPanel;
    public static final int SORT_ID = 0;
    public static final int SORT_NAME = 1;
    public static final int SORT_STATE = 2;
    int sortMode = 0;
    Hashtable bundles = new Hashtable();
    LF lf = LF.getLF();
    Container shutdownPanel = null;
    static final int ACTION_ID_BUNDLES_ID = 0;
    static final int ACTION_ID_BUNDLES_NAME = 1;
    static final int ACTION_ID_BUNDLES_STATE = 2;
    static final int ACTION_ID_CONSOLE = 3;
    static final int ACTION_ID_OBR = 4;
    static final int ACTION_ID_INSTALL = 5;
    static final int ACTION_ID_SHUTDOWN = 6;
    static final int ACTION_ID_REFRESH = 7;
    static final int ACTION_ID_BUNDLE_START = 20;
    static final int ACTION_ID_BUNDLE_STOP = 21;
    static final int ACTION_ID_BUNDLE_UPDATE = 22;
    static final int ACTION_ID_BUNDLE_UNINSTALL = 23;
    PopupMenu viewPopupMenu;
    Comp compName = new Comp(){

        public int compare(Bundle b0, Bundle b1) {
            String s0 = Util.getBundleName(b0).toLowerCase();
            String s1 = Util.getBundleName(b1).toLowerCase();
            return s0.compareTo(s1);
        }
    };
    Comp compId = new Comp(){

        public int compare(Bundle b0, Bundle b1) {
            return (int)(b0.getBundleId() - b1.getBundleId());
        }
    };
    Comp compState = new Comp(){

        public int compare(Bundle b0, Bundle b1) {
            return b0.getState() - b1.getState();
        }
    };
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    DesktopPanel() {
        this.setLayout(new BorderLayout());
        this.scroll = new ScrollPane(0);
        this.scroll.setSize(new Dimension(250, 300));
        this.cardLayout = new CardLayout();
        this.cardPanel = new Panel();
        this.cardPanel.setLayout(this.cardLayout);
        this.bundlePanel = new Panel();
        this.bundlePanel.setLayout(new GridLayout(0, 1));
        this.console = new Console();
        this.console.panel.text.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent ev) {
                String s = DesktopPanel.this.console.panel.text.getSelectedText();
                DesktopPanel.this.selectBundleFromText(s);
            }
        });
        this.openPanel = new InstallPanel();
        this.toolbar = new Toolbar();
        this.scroll.add(this.bundlePanel);
        this.cardPanel.add((Component)this.scroll, "bundles");
        this.cardLayout.addLayoutComponent("bundles", this.scroll);
        this.cardPanel.add((Component)this.console.panel, "console");
        this.cardLayout.addLayoutComponent("console", this.console.panel);
        this.cardPanel.add((Component)this.openPanel, "open");
        this.cardLayout.addLayoutComponent("open", this.openPanel);
        this.statusBar = new StatusBar();
        this.add((Component)this.cardPanel, "Center");
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.statusBar, "South");
        this.setBackground(this.lf.bgColor);
        this.bundlePanel.setBackground(Color.white);
        Activator.bc.addBundleListener((BundleListener)this);
        Bundle[] bl = Activator.bc.getBundles();
        for (int i = 0; bl != null && i < bl.length; ++i) {
            this.bundleChanged(new BundleEvent(1, bl[i]));
        }
        this.showBundles(this.sortMode);
    }

    public void bundleChanged(BundleEvent ev) {
        switch (ev.getType()) {
            case 1: {
                this.addBundle(ev.getBundle());
                this.rebuildBundles();
                break;
            }
            case 16: {
                this.removeBundle(ev.getBundle());
                this.rebuildBundles();
            }
        }
        this.bundleUpdated(ev.getBundle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundle(Bundle b) {
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            BundleC bc = (BundleC)this.bundles.get(b);
            if (bc != null) {
                this.bundles.remove(b);
                this.rebuildBundles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundle(Bundle b) {
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            if (!this.bundles.containsKey(b)) {
                BundleC bc = new BundleC(b);
                this.bundles.put(b, bc);
                this.rebuildBundles();
            }
        }
    }

    void insertBundle(Vector v, Bundle b, Comp comp) {
        for (int i = 0; i < v.size(); ++i) {
            Bundle b0 = (Bundle)v.elementAt(i);
            if (comp.compare(b, b0) > 0) continue;
            v.insertElementAt(b, i);
            return;
        }
        v.addElement(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebuildBundles() {
        Hashtable hashtable = this.bundles;
        synchronized (hashtable) {
            int sort = this.sortMode;
            try {
                BundleC bc;
                Bundle b;
                Comp comp = this.compId;
                if (sort == 0) {
                    comp = this.compId;
                } else if (sort == 1) {
                    comp = this.compName;
                } else if (sort == 2) {
                    comp = this.compState;
                }
                this.bundlePanel.removeAll();
                Vector sorted = new Vector();
                Enumeration e = this.bundles.keys();
                while (e.hasMoreElements()) {
                    b = (Bundle)e.nextElement();
                    bc = (BundleC)this.bundles.get(b);
                    this.insertBundle(sorted, b, comp);
                }
                for (int i = 0; i < sorted.size(); ++i) {
                    b = (Bundle)sorted.elementAt(i);
                    bc = (BundleC)this.bundles.get(b);
                    if (bc == null) {
                        bc = new BundleC(b);
                        this.bundles.put(b, bc);
                    }
                    this.bundlePanel.add(bc);
                }
                this.invalidate();
                this.bundlePanel.doLayout();
                this.bundlePanel.repaint();
                this.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void bundleUpdated(Bundle b) {
        BundleC bc = (BundleC)this.bundles.get(b);
        if (bc != null) {
            bc.bundleUpdated();
        }
    }

    void unselectAll() {
        Enumeration e = this.bundles.keys();
        while (e.hasMoreElements()) {
            Bundle b = (Bundle)e.nextElement();
            BundleC bc = (BundleC)this.bundles.get(b);
            if (!bc.isSelected()) continue;
            bc.bFocus = false;
            bc.setSelected(false);
        }
    }

    public void startBundles() {
        if (this.bundles.size() == 0) {
            this.statusBar.setMessage("No bundles selected");
            return;
        }
        Enumeration e = this.bundles.keys();
        while (e.hasMoreElements()) {
            Bundle b = (Bundle)e.nextElement();
            BundleC bc = (BundleC)this.bundles.get(b);
            if (!bc.isSelected()) continue;
            try {
                b.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void openBundle() {
        this.cardLayout.show(this.cardPanel, "open");
    }

    public void stopBundles() {
        if (this.bundles.size() == 0) {
            this.statusBar.setMessage("No bundles selected");
            return;
        }
        Enumeration e = this.bundles.keys();
        while (e.hasMoreElements()) {
            Bundle b = (Bundle)e.nextElement();
            BundleC bc = (BundleC)this.bundles.get(b);
            if (!bc.isSelected()) continue;
            try {
                b.stop();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void uninstallBundles() {
        if (this.bundles.size() == 0) {
            this.statusBar.setMessage("No bundles selected");
            return;
        }
        Enumeration e = this.bundles.keys();
        while (e.hasMoreElements()) {
            Bundle b = (Bundle)e.nextElement();
            BundleC bc = (BundleC)this.bundles.get(b);
            if (!bc.isSelected()) continue;
            try {
                b.uninstall();
                this.rebuildBundles();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateBundles() {
        if (this.bundles.size() == 0) {
            this.statusBar.setMessage("No bundles selected");
            return;
        }
        Enumeration e = this.bundles.keys();
        while (e.hasMoreElements()) {
            Bundle b = (Bundle)e.nextElement();
            BundleC bc = (BundleC)this.bundles.get(b);
            if (!bc.isSelected()) continue;
            try {
                b.update();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void selectBundleFromText(String s) {
        this.unselectAll();
        if (s != null && s.length() > 0) {
            s = s.trim();
            try {
                long bid = Long.parseLong(s);
                Enumeration e = this.bundles.keys();
                while (e.hasMoreElements()) {
                    Bundle b = (Bundle)e.nextElement();
                    BundleC bc = (BundleC)this.bundles.get(b);
                    if (b.getBundleId() != bid) continue;
                    bc.setSelected(true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void showBundles(int sort) {
        this.sortMode = sort;
        this.rebuildBundles();
        this.cardLayout.show(this.cardPanel, "bundles");
    }

    void showConsole() {
        this.cardLayout.show(this.cardPanel, "console");
    }

    void showOBR() {
        this.cardLayout.show(this.cardPanel, "obr");
    }

    void showInstall() {
        this.cardLayout.show(this.cardPanel, "install");
    }

    void showInfo(BundleC bc) {
        if (bc != null) {
            // empty if block
        }
    }

    void shutdown() {
        if (this.shutdownPanel == null) {
            this.shutdownPanel = new ShutdownPanel();
            this.cardPanel.add((Component)this.shutdownPanel, "shutdown");
            this.shutdownPanel.doLayout();
            this.shutdownPanel.invalidate();
            this.cardLayout.addLayoutComponent("shutdown", this.shutdownPanel);
        }
        this.cardLayout.show(this.cardPanel, "shutdown");
    }

    void handleAction(int actionId) {
        switch (actionId) {
            case 0: {
                this.showBundles(0);
                break;
            }
            case 1: {
                this.showBundles(1);
                break;
            }
            case 2: {
                this.showBundles(2);
                break;
            }
            case 3: {
                this.showConsole();
                break;
            }
            case 4: {
                this.showOBR();
                break;
            }
            case 5: {
                this.openBundle();
                break;
            }
            case 7: {
                this.refreshBundles(null);
                break;
            }
            case 6: {
                this.shutdown();
                break;
            }
            case 20: {
                this.startBundles();
                break;
            }
            case 21: {
                this.stopBundles();
                break;
            }
            case 22: {
                this.updateBundles();
                break;
            }
            case 23: {
                this.uninstallBundles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshBundles(Bundle[] bl) {
        ServiceReference sr = Activator.bc.getServiceReference((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = DesktopPanel.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName());
        if (sr != null) {
            PackageAdmin packageAdmin = null;
            try {
                packageAdmin = (PackageAdmin)Activator.bc.getService(sr);
                if (packageAdmin != null) {
                    if (bl != null && bl.length == 0) {
                        bl = null;
                    }
                    packageAdmin.refreshPackages(bl);
                }
            }
            finally {
                if (packageAdmin != null) {
                    Activator.bc.ungetService(sr);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface Comp {
        public int compare(Bundle var1, Bundle var2);
    }

    class StatusBar
    extends Container {
        Dimension pSize;
        String msg;

        StatusBar() {
            this.pSize = new Dimension(100, DesktopPanel.this.lf.defaultFont.getSize() + 4);
            this.msg = "";
        }

        public Dimension preferredSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.pSize;
        }

        public void showBundles() {
            int nTotal = DesktopPanel.this.bundles.size();
            int nSelected = 0;
            StringBuffer sb = new StringBuffer();
            Enumeration e = DesktopPanel.this.bundles.keys();
            while (e.hasMoreElements()) {
                Bundle b = (Bundle)e.nextElement();
                BundleC bc = (BundleC)DesktopPanel.this.bundles.get(b);
                if (!bc.isSelected()) continue;
                ++nSelected;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("#" + b.getBundleId() + "/" + Util.getBundleName(b));
            }
            if (sb.length() > 20) {
                sb.setLength(20);
                sb.append("...");
            }
            String msg = "Total " + nTotal + ", " + nSelected + " selected" + " " + sb;
            this.setMessage(msg);
        }

        public void setMessage(String msg) {
            this.msg = msg;
            this.repaint();
        }

        public void paint(Graphics g) {
            super.paint(g);
            g.setFont(DesktopPanel.this.lf.defaultFont);
            g.setColor(DesktopPanel.this.lf.ttText);
            if (this.msg != null) {
                g.drawString(this.msg, 2, DesktopPanel.this.lf.defaultFont.getSize() + 2);
            }
            g.setColor(Color.gray);
        }
    }

    class Toolbar
    extends Panel {
        LF lf = LF.getLF();

        Toolbar() {
            super(new FlowLayout(0));
            this.setBackground(this.lf.bgColor);
            ImageLabel viewButton = new ImageLabel(this, "/view_select.gif", 2, this.getBackground()){
                private final /* synthetic */ Toolbar this$1;
                {
                    this.this$1 = this$1;
                }

                public void setFocus(boolean b) {
                    super.setFocus(b);
                    Toolbar.access$100((Toolbar)this.this$1).statusBar.setMessage(b ? "Select view" : "");
                }
            };
            DesktopPanel.this.viewPopupMenu = new PopupMenu();
            this.add(DesktopPanel.this.viewPopupMenu);
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Bundles (id)", 0));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Bundles (name)", 1));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Bundles (state)", 2));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Console", 3));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("OBR (NYI)", 4));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Shutdown", 6));
            DesktopPanel.this.viewPopupMenu.add(new ActionMenuItem("Refresh", 7));
            this.add(viewButton);
            viewButton.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ Toolbar this$1;
                {
                    this.this$1 = this$1;
                }

                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (Toolbar.access$100((Toolbar)this.this$1).viewPopupMenu != null) {
                        Component comp = e.getComponent();
                        Toolbar.access$100((Toolbar)this.this$1).viewPopupMenu.show(comp, 0, comp.getSize().height);
                    }
                }
            });
            this.add(new ActionImageLabel("/open.gif", this.getBackground(), "Install bundles", 5));
            this.add(new ActionImageLabel("/player_play.gif", this.getBackground(), "Start bundles", 20));
            this.add(new ActionImageLabel("/player_stop.gif", this.getBackground(), "Stop bundles", 21));
            this.add(new ActionImageLabel("/update.gif", this.getBackground(), "Update bundles", 22));
            this.add(new ActionImageLabel("/player_eject.gif", this.getBackground(), "Uninstall bundles", 23));
        }

        static /* synthetic */ DesktopPanel access$100(Toolbar x0) {
            return x0.DesktopPanel.this;
        }
    }

    class ActionImageLabel
    extends ImageLabel
    implements ActionListener {
        int actionId;
        String tt;

        ActionImageLabel(String name, Color bg, String tt, int actionId) {
            super(name, 2, bg);
            this.actionId = actionId;
            this.tt = tt;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ev) {
            DesktopPanel.this.handleAction(this.actionId);
        }

        public void setFocus(boolean b) {
            super.setFocus(b);
            DesktopPanel.this.statusBar.setMessage(b ? this.tt : "");
        }
    }

    class ActionMenuItem
    extends MenuItem
    implements ActionListener {
        int actionId;

        ActionMenuItem(String name, int actionId) {
            super(name);
            this.actionId = actionId;
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent ev) {
            DesktopPanel.this.handleAction(this.actionId);
        }
    }

    class BundleC
    extends DBContainer {
        boolean bSelected = false;
        boolean bFocus = false;
        String lab;
        String lab2;
        Bundle b;
        Image bundleImage;
        Dimension imgSize;
        long maxPaintTime = 30L;
        Color alphaCol = new Color(0, 0, 0, 255);

        BundleC(Bundle _b) {
            this.b = _b;
            this.bundleImage = Util.hasActivator(this.b) ? Desktop.bundleImage : Desktop.libImage;
            this.imgSize = new Dimension(this.bundleImage.getWidth(null), this.bundleImage.getHeight(null));
            MouseAdapter mouseListener = new MouseAdapter(this, DesktopPanel.this){
                private final /* synthetic */ DesktopPanel val$this$0;
                private final /* synthetic */ BundleC this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void mouseClicked(MouseEvent ev) {
                    BundleC.access$000(this.this$1).unselectAll();
                    this.this$1.setSelected(true);
                }

                public void mouseEntered(MouseEvent ev) {
                    if (this.this$1.paintTime < this.this$1.maxPaintTime) {
                        BundleC.access$000(this.this$1).showInfo(this.this$1);
                        this.this$1.setFocus(true);
                    }
                }

                public void mouseExited(MouseEvent ev) {
                    if (this.this$1.paintTime < this.this$1.maxPaintTime) {
                        BundleC.access$000(this.this$1).showInfo(null);
                        this.this$1.setFocus(false);
                    }
                }
            };
            this.lab = Util.getBundleName(this.b);
            this.lab2 = "";
            this.addMouseListener(mouseListener);
            this.bundleUpdated();
        }

        void paintImage(Graphics g) {
            Image overlay = null;
            switch (this.b.getState()) {
                case 32: {
                    overlay = Desktop.activeIcon;
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
                case 1: {
                    break;
                }
            }
            Dimension size = this.getSize();
            int x = 0;
            int y = 0;
            g.drawImage(this.bundleImage, x, y, null);
            if (overlay != null) {
                int w = overlay.getWidth(null);
                int h = overlay.getHeight(null);
                int x1 = x + (this.imgSize.width - w - 2);
                int y1 = y + (this.imgSize.height - h - 2);
                g.drawImage(overlay, x1, y1, this.alphaCol, null);
            }
        }

        public void paintComponent(Graphics g) {
            try {
                ++DBContainer.count;
            }
            catch (Exception e) {
                // empty catch block
            }
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            int left = 2 + this.bundleImage.getWidth(null);
            int ypos = 2;
            this.paintImage(g);
            g.setColor(Color.black);
            g.setFont(DesktopPanel.this.lf.defaultFont);
            g.drawString(this.lab, left, ypos += g.getFont().getSize());
            g.setColor(Color.gray);
            g.setFont(DesktopPanel.this.lf.smallFont);
            g.drawString(this.lab2, left, ypos += g.getFont().getSize() + 2);
            ypos += g.getFont().getSize() + 2;
            long t1 = System.currentTimeMillis();
        }

        public Dimension preferredSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return this.imgSize;
        }

        void bundleUpdated() {
            int maxLen = 25;
            String desc = Util.getHeader(this.b, "Bundle-Description", "");
            if (desc == null) {
                desc = "";
            }
            if (desc.length() > maxLen) {
                desc = desc.substring(0, maxLen) + "...";
            }
            this.lab2 = desc + " (#" + this.b.getBundleId() + ", " + Util.stateName(this.b.getState()) + ")";
            this.bNeedRedraw = true;
            this.repaint();
        }

        public boolean isSelected() {
            return this.bSelected;
        }

        public void setFocus(boolean b) {
            if (this.bFocus == b) {
                return;
            }
            this.bFocus = b;
            this.bNeedRedraw = true;
            this.setSelected(this.isSelected());
        }

        public boolean isFocus() {
            return this.bFocus;
        }

        public void setSelected(boolean b) {
            Color c;
            if (this.bSelected != b) {
                this.bNeedRedraw = true;
            }
            this.bSelected = b;
            Color color = c = this.isSelected() ? LF.getLF().stdSelectedCol : Color.white;
            if (this.isFocus()) {
                c = Util.rgbInterpolate(c, Color.gray, 0.1);
            }
            this.setBackground(c);
            this.repaint();
            DesktopPanel.this.statusBar.showBundles();
        }

        static /* synthetic */ DesktopPanel access$000(BundleC x0) {
            return x0.DesktopPanel.this;
        }
    }
}

