/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import org.knopflerfish.bundle.desktopawt.Activator;
import org.knopflerfish.bundle.desktopawt.DesktopPanel;

class Desktop {
    static Frame frame;
    DesktopPanel dp;
    static MediaTracker tracker;
    static int trackerId;
    static Image activeIcon;
    static Image bundleImage;
    static Image libImage;

    Desktop() {
        frame = new Frame("Knopflerfish Desktop");
        tracker = new MediaTracker(frame);
        activeIcon = Desktop.loadImage("/player_play_14x14.gif");
        bundleImage = Desktop.loadImage("/bundle.gif");
        libImage = Desktop.loadImage("/lib.gif");
        this.setIcon(frame, "/kf_");
    }

    static Image loadImage(String urlS) {
        try {
            URL url = Activator.bc.getBundle().getResource(urlS);
            if (url == null) {
                throw new RuntimeException("No image " + urlS);
            }
            Image img = Toolkit.getDefaultToolkit().createImage(url);
            int id = trackerId++;
            tracker.addImage(img, id);
            tracker.waitForID(id);
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to load image " + urlS + ", " + e);
        }
    }

    public void open() {
        this.dp = new DesktopPanel();
        frame.add(this.dp);
        ((Component)frame).setSize(new Dimension(200, 400));
        frame.pack();
        frame.show();
    }

    public void close() {
        if (frame != null) {
            frame.hide();
            frame = null;
            tracker = null;
        }
    }

    public void setIcon(Frame frame, String baseName) {
        String iconName = baseName + "32x32.gif";
        if (System.getProperty("os.name", "").startsWith("Win")) {
            iconName = baseName + "16x16.gif";
        }
        String strURL = iconName;
        try {
            Image image = Desktop.loadImage(strURL);
            frame.setIconImage(image);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        trackerId = 0;
        activeIcon = null;
    }
}

