/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.bundle.desktopawt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.knopflerfish.bundle.desktopawt.LF;
import org.knopflerfish.bundle.desktopawt.PrefixPrintStream;
import org.knopflerfish.bundle.desktopawt.TextAreaOutputStream;
import org.knopflerfish.bundle.desktopawt.TextReader;
import org.knopflerfish.bundle.desktopawt.Util;

public class ConsoleAWT
extends Panel {
    LF lf = LF.getLF();
    TextArea text;
    TextField tfCmd;
    int p0 = -1;
    int p1 = 0;
    String last = "";
    InputStream origIn;
    PrintStream origOut;
    PrintStream origErr;
    PipedOutputStream textSource;
    TextReader in;
    PrintStream out;
    Container panel;
    ScrollPane scroll;
    Label cmdLabel;
    Vector history = new Vector();
    int historyPos = 0;
    StringBuffer lineBuff = new StringBuffer();
    boolean bGrabbed = false;
    static boolean multiplexSystemOut = true;
    static boolean multiplexSystemErr = true;
    static boolean grabSystemIO = true;
    Dimension pSize = new Dimension(100, 200);

    public ConsoleAWT() {
        this.setLayout(new BorderLayout());
        this.panel = this;
        ConsoleAWT.log("ConsoleAWT()");
        try {
            this.text = new TextArea("", 0, 40){

                public Dimension preferredSize() {
                    return this.getPreferredSize();
                }

                public Dimension getPreferredSize() {
                    return ConsoleAWT.this.pSize;
                }
            };
            this.text.setSize(this.pSize);
            this.text.setEditable(false);
            String bootText = "Knopflerfish OSGi console. Copyright (c) 2004 Knopflerfish.";
            try {
                Class<?> mainClazz = Class.forName("org.knopflerfish.framework.Main");
                bootText = (String)mainClazz.getField("bootText").get(null);
            }
            catch (Throwable e) {
                bootText = "";
            }
            this.text.setText(bootText + "\n\n" + "Type 'help' for help or 'alias' for a list of common commands\n\n");
            this.tfCmd = new TextField();
            KeyAdapter keyL = new KeyAdapter(){

                public void keyPressed(KeyEvent ev) {
                    if (ev.getKeyCode() == 38) {
                        if (ConsoleAWT.this.historyPos > 0) {
                            String line = (String)ConsoleAWT.this.history.elementAt(ConsoleAWT.this.historyPos - 1);
                            --ConsoleAWT.this.historyPos;
                            ConsoleAWT.this.tfCmd.setText(line);
                        }
                    } else if (ev.getKeyCode() == 40) {
                        if (ConsoleAWT.this.historyPos < ConsoleAWT.this.history.size() - 1) {
                            String line = (String)ConsoleAWT.this.history.elementAt(ConsoleAWT.this.historyPos + 1);
                            ++ConsoleAWT.this.historyPos;
                            ConsoleAWT.this.tfCmd.setText(line);
                        }
                    } else if (ev.getKeyCode() == 10) {
                        String line = ConsoleAWT.this.tfCmd.getText();
                        if (!("".equals(line) || "\n".equals(line) || "\n\r".equals(line) || "\r\n".equals(line))) {
                            ConsoleAWT.this.history.addElement(line);
                            ConsoleAWT.this.historyPos = ConsoleAWT.this.history.size();
                        }
                        if ("clear".equals(line)) {
                            ConsoleAWT.this.clear();
                        } else if (!"quit".equals(line)) {
                            if (line.startsWith("!") && line.length() > 1) {
                                String s2 = line.substring(1);
                                String bestStr = "";
                                for (int i = 0; i < ConsoleAWT.this.history.size(); ++i) {
                                    String s = (String)ConsoleAWT.this.history.elementAt(i);
                                    if (!s.startsWith(s2) && s.length() < bestStr.length()) continue;
                                    bestStr = s;
                                }
                                if (!"".equals(bestStr)) {
                                    line = bestStr;
                                }
                            }
                            String s = line + "\r\n";
                            ConsoleAWT.this.text.append(s);
                            ConsoleAWT.this.showLastLine();
                            if (ConsoleAWT.this.in != null) {
                                ConsoleAWT.this.in.print(s);
                                ConsoleAWT.this.in.flush();
                            }
                        }
                        ConsoleAWT.this.tfCmd.setText("");
                    }
                }
            };
            this.tfCmd.addKeyListener(keyL);
            this.text.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ev) {
                    int modifiers = ev.getModifiers();
                    if (modifiers == 0) {
                        ConsoleAWT.this.tfCmd.requestFocus();
                    }
                }
            });
            this.out = new PrintStream(new TextAreaOutputStream(this, this.text));
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.panel.add((Component)this.text, "Center");
            Panel cmdPanel = new Panel(new BorderLayout());
            this.cmdLabel = new Label("> ");
            cmdPanel.add((Component)this.cmdLabel, "West");
            cmdPanel.add((Component)this.tfCmd, "Center");
            this.panel.add((Component)cmdPanel, "North");
            final PopupMenu cmdPopupMenu = new PopupMenu();
            cmdPopupMenu.add(new CommandItem("ps -1", true));
            cmdPopupMenu.add(new CommandItem("log", true));
            cmdPopupMenu.add(new CommandItem("/fr refresh", true));
            cmdPopupMenu.add(new CommandItem("obr list", true));
            cmdPopupMenu.add(new CommandItem("start <sel>", false));
            cmdPopupMenu.add(new CommandItem("stop <sel>", false));
            cmdPopupMenu.add(new CommandItem("update <sel>", false));
            cmdPopupMenu.add(new CommandItem("obr install =<sel>", false));
            cmdPopupMenu.add(new CommandItem("obr start =<sel>", false));
            cmdPopupMenu.add(new CommandItem("<sel>", false));
            this.cmdLabel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    this.showPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    this.showPopup(e);
                }

                private void showPopup(MouseEvent e) {
                    if (cmdPopupMenu != null) {
                        Component comp = e.getComponent();
                        cmdPopupMenu.show(comp, 0, comp.getSize().height);
                    }
                }
            });
            this.cmdLabel.add(cmdPopupMenu);
            this.reinit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void log(String msg) {
        ConsoleAWT.log(msg, null);
    }

    static void log(String msg, Exception e) {
    }

    void setSystemIO() {
        boolean bDebugClass = "true".equals(System.getProperty("org.knopflerfish.framework.debug.classloader", "false"));
        if (!bDebugClass && !this.bGrabbed) {
            try {
                ConsoleAWT.log("grabbing system I/O...");
                this.origIn = System.in;
                this.origOut = System.out;
                this.origErr = System.err;
                System.setOut(new PrefixPrintStream(this.out, "[stdout] ", multiplexSystemOut ? System.out : null));
                System.setErr(new PrefixPrintStream(this.out, "[stderr] ", multiplexSystemErr ? System.err : null));
                this.bGrabbed = true;
                ConsoleAWT.log("...grabbed system I/O");
            }
            catch (Exception e) {
                ConsoleAWT.log("Failed to set IO", e);
                this.bGrabbed = false;
            }
        }
    }

    void restoreSystemIO() {
        if (this.bGrabbed) {
            ConsoleAWT.log("restoring system I/O...");
            try {
                if (this.origIn != null) {
                    System.setIn(this.origIn);
                }
                if (this.origOut != null) {
                    System.setOut(this.origOut);
                }
                if (this.origIn != null) {
                    System.setErr(this.origErr);
                }
                ConsoleAWT.log("...restored system I/O");
                this.bGrabbed = false;
            }
            catch (Exception e) {
                ConsoleAWT.log("Failed to restore IO", e);
            }
        }
    }

    void clear() {
        this.text.setText("");
    }

    void showLastLine() {
    }

    synchronized void reinit() {
        this.text.setBackground(this.lf.bgColor);
        this.text.setForeground(this.lf.textColor);
        this.text.setFont(this.lf.smallFixedFont);
        this.tfCmd.setBackground(this.text.getBackground());
        this.tfCmd.setForeground(this.text.getForeground());
        this.tfCmd.setFont(this.lf.defaultFixedFont);
        this.cmdLabel.setBackground(this.tfCmd.getBackground());
        this.cmdLabel.setForeground(this.tfCmd.getForeground());
        this.cmdLabel.setFont(this.tfCmd.getFont());
    }

    void start() {
        ConsoleAWT.log("starting ConsoleAWT");
        this.stop();
        this.in = new TextReader();
        this.setVisible(true);
        if (grabSystemIO) {
            this.setSystemIO();
        }
        ConsoleAWT.log("started ConsoleAWT");
    }

    void stop() {
        if (grabSystemIO) {
            this.restoreSystemIO();
        }
        this.setVisible(false);
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    class CommandItem
    extends MenuItem {
        public CommandItem(String cmd, boolean bDirect) {
            super(cmd);
            this.addActionListener(new ActionListener(this, cmd, bDirect){
                private final /* synthetic */ String val$cmd;
                private final /* synthetic */ boolean val$bDirect;
                private final /* synthetic */ CommandItem this$1;
                {
                    this.this$1 = this$1;
                    this.val$cmd = val$cmd;
                    this.val$bDirect = val$bDirect;
                }

                public void actionPerformed(ActionEvent ev) {
                    String s = this.val$cmd;
                    String sel = CommandItem.access$000((CommandItem)this.this$1).text.getSelectedText();
                    if (sel != null) {
                        sel = sel.trim();
                        s = Util.replace(s, "<sel>", sel);
                    }
                    if (this.val$bDirect) {
                        CommandItem.access$000((CommandItem)this.this$1).in.print(s + "\r\n");
                        CommandItem.access$000((CommandItem)this.this$1).in.flush();
                    } else {
                        CommandItem.access$000((CommandItem)this.this$1).tfCmd.setText(s);
                    }
                }
            });
        }

        static /* synthetic */ ConsoleAWT access$000(CommandItem x0) {
            return x0.ConsoleAWT.this;
        }
    }
}

